/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.logistics.item.guide.cooking;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.content.logistics.item.guide.cooking.CookingGuideMenu;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CookingGuideScreen
extends AbstractSimiContainerScreen<CookingGuideMenu> {
    private static final ResourceLocation TEXTURE = CentralKitchen.genRL("textures/gui/cooking_guide.png");
    private static final int WINDOW_WIDTH = 176;
    private static final int BACKGROUND_WIDTH = 184;
    private static final int BACKGROUND_HEIGHT = 80;
    private static final int ICON_SIZE = 48;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public CookingGuideScreen(CookingGuideMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void m_7856_() {
        this.setWindowSize(184, 84 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-40, 0);
        super.m_7856_();
        int guideX = this.getLeftOfCentered(176);
        int guideY = this.f_97736_;
        this.extraAreas = ImmutableList.of((Object)new Rect2i(guideX + 176 + 16, guideY + 16, 48, 48), (Object)new Rect2i(guideX, guideY, this.f_97726_, this.f_97727_));
    }

    protected void m_7286_(@NotNull PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + 80 + 4;
        this.renderPlayerInventory(pose, invX, invY);
        int guideX = this.getLeftOfCentered(176);
        int guideY = this.f_97736_;
        this.renderGuide(pose, guideX, guideY);
        CookingGuideScreen.m_93215_((PoseStack)pose, (Font)this.f_96547_, (Component)this.f_96539_, (int)(guideX + 88), (int)(guideY + 5), (int)0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((ItemStack)((CookingGuideMenu)this.f_97732_).contentHolder)).at((float)(guideX + 176 + 16), (float)(guideY + 16), -200.0f)).scale(3.0).render(pose);
    }

    private void renderGuide(@NotNull PoseStack pose, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, x, y, 0, 0, 184, 80);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int status = ((CookingGuideMenu)this.m_6262_()).getBlazeStatus();
        if (level == null || status <= 0) {
            this.m_93228_(pose, x + 88, y + 24, 0, 80, 24, 24);
        } else {
            int time = (int)level.m_46467_() / 5 % 3 + 1;
            this.m_93228_(pose, x + 88, y + 24, 24 * time, 80, 24, 24);
        }
        this.m_93228_(pose, x + 80, y + 66, 96, 80 + status * 6, 80, 6);
    }

    protected void m_7025_(@NotNull PoseStack pose, int x, int y) {
        if (((CookingGuideMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            if (this.f_97734_.f_40219_ == 6) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                ItemStack mealStack = this.f_97734_.m_7993_();
                tooltip.add(((MutableComponent)mealStack.m_41720_().m_41466_()).m_130938_(mealStack.m_41791_().getStyleModifier()));
                ItemStack containerStack = ((CookingGuideMenu)this.m_6262_()).getContainerItem();
                String container = !containerStack.m_41619_() ? containerStack.m_41720_().m_41466_().getString() : "";
                tooltip.add(TextUtils.getTranslation((String)"container.cooking_pot.served_on", (Object[])new Object[]{container}).m_130940_(ChatFormatting.GRAY));
                this.m_96597_(pose, tooltip, x, y);
            } else {
                this.m_6057_(pose, this.f_97734_.m_7993_(), x, y);
            }
        }
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

